// Auth relay — runs in ISOLATED world on inclawbate.com pages
// Listens for postMessage from auth-read.js (MAIN world) and relays to extension background

window.addEventListener('message', (event) => {
    if (event.source !== window) return;
    if (!event.data || event.data.type !== 'inclawbate-auth') return;

    chrome.runtime.sendMessage({
        action: 'set-api-key',
        apiKey: event.data.apiKey,
        token: event.data.token,
        xHandle: event.data.xHandle,
        walletAddress: event.data.walletAddress
    });
});
